*
* DHCP IMPLEMENTATION
* WE ARE GOING TO TRY TO STAY AS CLOSE TO RFC 2131 AS WE CAN.
*
* FIRST WE WILL SEND OUT SOME DHCP DISCOVERIES. IF THERE'S NO
* RESPONSE AFTER A WHILE WE WILL CONFIGURE A LINK-LOCAL ADDRESS.
* BUT FROM TIME TO TIME, WE CAN SEND OUT A DHCP DISCOVERY IN THE
* HOPE THAT A SERVER MAY EVENTUALLY RESPOND.
*
DHCPSERVPORT EQU 67 ; DEST PORT FOR DHCP SERVER
DHCPCLIPORT EQU 68 ; OUR LOCAL SOURCE PORT
*
DHCPSTAT DFB 0 ; CURRENT DHCP STATE
DHCPSECS DS 2 ; SECONDS SINCE DHCP PROCESS STARTED
DHCPSERVER DS 4 ; DHCP SERVER IP ADDRESS
DHCPXID DS 4 ; CLIENT TRANSACTION ID
DHCPYADDR DS 4 ; ASSIGNED CLIENT IP
DHCPLETIME DS 4 ; LEASE TIME IN SECONDS
*
DHCPDINUM DFB 2 ; NUMBER OF INITIAL DHCP DISCOVERIES
*
*
* DHCP INIT
* THIS ONLY NEEDS TO BE CALLED ONCE AT SYSTEM INIT TIME.
*
DHCPINIT
 LDA #0
 STA DHCPSECS
 STA DHCPSECS+1
 STA DHCPSTAT ; CLEAR DHCP STATUS
 LDA #2
 STA DHCPDINUM ; INITIAL DHCP DISCOVERIES
* COPY OUR MAC INTO DHCP TEMPLATES
 LDX #5 ; OURMAC OFFSET
 LDY #21 ; DHCPDATOPT OFFSET
:L LDA OURMAC,X
 STA DHCPDATOPT,Y ; DISCOVER
 STA DHCPREQOPT,Y ; REQUEST
 DEY
 DEX
 BPL :L
* COPY OUR MAC INTO DHCP DECLINE TEMPLATE
 LDX #5 ; OURMAC OFFSET
 LDY #11 ; DHCPDECOPT OFFSET
:L2 LDA OURMAC,X
 STA DHCPDECOPT,Y
 DEY
 DEX
 BPL :L2
* COPY MAC INTO CLIENT HARDWARE ADDRESS TOO
 LDX #5
 LDY #33 ; DHCPDAT OFFSET
:L3 LDA OURMAC,X
 STA DHCPDAT,Y ; DISCOVER
 STA DHCPREQDAT,Y ; REQUEST
 STA DHCPDECDAT,Y ; DECLINE
 DEY
 DEX
 BPL :L3 ; FALL INTO DHCPGENTXID
*
* GENERATE A TRANSACTION ID
* THIS ONLY NEEDS TO BE CALLED ONCE AT SYSTEM INIT TIME.
* SEE ALTERNATE ENTRY POINT BELOW.
DHCPGENTXID
 LDA RNDL
 EOR #$FF
 STA DHCPXID
 LDA RNDH
 EOR #$AA
 STA DHCPXID+1
 INC RNDL
 LDA RNDL
 EOR OURMAC+2
 STA DHCPXID+2
 INC RNDH
 LDA RNDH
 EOR OURMAC+3
 STA DHCPXID+3
* INCREMENT EXISTING TXID
DHCPNEXTID
 INC DHCPXID+3
 BNE :DONE
 INC DHCPXID+2
:DONE RTS
*
* DHCP DISCOVER
* SEE ALTERNATE ENTRY POINT BELOW.
DHCPSENDDISC
 LDA #0
 STA DHCPSTAT
 LDA #<DHCPDAT
 STA OUTPBUF
 LDA #>DHCPDAT
 STA OUTPBUF+1
* DHCP BASICS
 LDA #1 ; MESSAGE TYPE...
 STA DHCPDAT ; BOOT REQUEST
 STA DHCPDATOPT+2 ; DHCP DISCOVER
* COPY DHCP TRANSACTION ID
 LDY #3
 LDX #7
:L LDA DHCPXID,Y
 STA DHCPDAT,X
 DEX
 DEY
 BPL :L
* COPY SECONDS ELAPSED
 INC DHCPSECS
 BNE :S
 INC DHCPSECS+1
:S LDA DHCPSECS
 STA DHCPDAT+9 ; OFFSET FOR SECS
 LDA DHCPSECS+1 ; HIGH-BYTE
 STA DHCPDAT+8
* REQUEST LENGTH
 LDA #<DHCPDATLEN
 STA OUTPLEN
 LDA #>DHCPDATLEN
 STA OUTPLEN+1
*
 DO DEBUG
 LDY #0
:ML LDA MSG17,Y
 BEQ DHCPSEND2
 JSR COUT
 INY
 BNE :ML
 FIN
*
* ALTERNATE ENTRY POINT FOR SENDING OTHER DHCP MESSAGES
DHCPSEND2
* AUTOMATIC ID GENERATED
 LDA #0
 LDX #18
 STA OUTPHEAD,X
 INX
 STA OUTPHEAD,X
* DEFAULT TTL
 LDX #22
 LDA #0
 STA OUTPHEAD,X
* SOURCE IP 0.0.0.0
 LDY #3
 LDX #29
:L2 STA OUTPHEAD,X
 DEX
 DEY
 BPL :L2
* DESTINATION BROADCAST
 LDA #$FF
 LDY #3
 LDX #33
:L3 STA OUTPHEAD,X
 DEX
 DEY
 BPL :L3
* SET UDP PORTS
 LDA #DHCPCLIPORT
 LDX #35
 STA OUTPHEAD,X
 DEX
 LDA #0
 STA OUTPHEAD,X
 LDA #DHCPSERVPORT
 LDX #37
 STA OUTPHEAD,X
 DEX
 LDA #0
 STA OUTPHEAD,X
 JSR UDPSEND
 RTS
*
*
* DATA TEMPLATE FOR DHCP DISCOVER MESSAGES
DHCPDAT
 HEX 01010600
 HEX 00000000
 HEX 00000000
 DS 16 ; 4 IP ADDRESSES
 DS 16 ; CLIENT HARDWARE ADDRESS
 DS 192 ; BOOTP LEGACY FIELD
 HEX 63825363 ; MAGIC COOKIE
DHCPDATOPT
 HEX 350101 ; DHCP MESSAGE TYPE
 HEX 37040103060F ; PARAM REQUEST LIST
 HEX 390205DC ; MAX DHCP MESSAGE SIZE
 HEX 3D0701000000000000 ; CLIENT ID
 HEX 33040076A700 ; LEASE TIME
 HEX FF ; OPTION END
 HEX 00 ; PAD
DHCPDATLEN EQU *-DHCPDAT
*
*
* DHCP REPLY
* THIS IS THE CENTRAL ENTRY POINT FOR ALL REPLIES FROM
* THE DHCP SERVER: OFFER, ACK, AND NAK.
DHCPREPLY
 LDY #1 ; NOW AT LOW-BYTE OF SOURCE PORT
 LDA (INPBUF),Y
 CMP #DHCPSERVPORT ; CORRECT PORT NUMBER?
 BNE :ERRDONE ; NO, SO EXIT
 DEY  ; NOW AT HIGH-BYTE OF SRC PORT
 LDA (INPBUF),Y
 BEQ :CHECKLEN ; LOOKS GOOD, SO MOVE ON
:ERRDONE
 DO DEBUG
 LDA #"E"
 JSR COUT
 FIN
 SEC
 RTS
* REPLY LENGTH MUST BE AT LEAST 236 BYTES
:CHECKLEN
 LDA UDPDATLEN
 CMP #236 ; MINIMUM DHCP REPLY LENGTH
 LDA UDPDATLEN+1
 SBC #0 ; HIGH-BYTE
 BCC :ERRDONE ; TOO SHORT!
* MESSAGE TYPE MUST BE BOOT REPLY (2)
:CHECKTYPE
 CLC
 LDA INPBUF
 ADC #8 ; ADVANCE POINTER PAST UDP HEAD
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
 LDY #0 ; POINT TO MESSAGE TYPE
 LDA (INPBUF),Y
 CMP #2 ; BOOT REPLY
 BNE :ERRDONE ; NO GOOD
* CHECK TRANSACTION ID
 LDY #7 ; OFFSET IN INPBUF
 LDX #3 ; DHCPXID OFFSET
:L LDA (INPBUF),Y
 CMP DHCPXID,X
 BNE :ERRDONE ; NOT A MATCH
 DEY
 DEX
 BPL :L
* CHECK CLIENT HARDWARE ADDRESS
 LDY #33 ; OFFSET IN INPBUF
 LDX #5 ; OURMAC OFFSET
:L2 LDA (INPBUF),Y
 CMP OURMAC,X
 BNE :ERRDONE ; NOT A MATCH
 DEY
 DEX
 BPL :L2
* NOW WE NEED TO CHECK THE OPTIONS FIELD
* BY ADDING 240 TO INPBUF.
 CLC
 LDA INPBUF
 ADC #240
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
* NOW CALL THE OPTION SCANNER TO FIND DHCP MESSAGE TYPE
 LDA #53
 JSR DHCPSCANOPT
* THIS ERROR SHOULD NEVER HAPPEN, BUT JUST IN CASE...
 BCS :ERRDONE ; MESSAGE TYPE NOT FOUND
 INY  ; POINT TO OPT LEN
 INY  ; POINT TO OPT DATA
 LDA (INPBUF),Y ; GET MESSAGE TYPE
 CMP #2 ; DHCP OFFER?
 BEQ :OFFER
 CMP #5 ; DHCP ACK?
 BEQ :ACK
 CMP #6 ; DHCP NAK?
 BEQ :NAK
 BRK
*
*
:OFFER
 LDA DHCPSTAT ; CHECK CLIENT STATUS
 BEQ :OFFER2 ; MUST BE ZERO
 RTS
:OFFER2  ; VERIFY YOUR ADDRESS
 LDY #16 ; OFFSET TO YOUR ADDRESS
:YADRL LDA (INPBUF),Y
 BNE :OFFER3 ; BREAK ON ANY NON-ZERO BYTE
 INY
 CPY #20
 BNE :YADRL
 SEC
 RTS  ; ALL ZERO ADDRESS IS ILLEGAL
:OFFER3
 LDA #54 ; SERVER IDENTIFIER
 JSR DHCPSCANOPT
 BCC :OFFER4 ; OPTION FOUND
 RTS ; NOT FOUND, SHOULD NOT HAPPEN
:OFFER4
 LDA #1 ; UPDATE CLIENT STATUS
 STA DHCPSTAT
 TYA
 CLC
 ADC #5 ; POINT TO END OF IP ADDRESS
 TAY
 LDX #3
:OFL LDA (INPBUF),Y
 STA DHCPSERVER,X
 DEY
 DEX
 BPL :OFL
* ROLL BACK TO INPBUF TO HEAD OF DHCP OFFER
 SEC
 LDA INPBUF
 SBC #240
 STA INPBUF
 LDA INPBUF+1
 SBC #0
 STA INPBUF+1
* COPY YADDR (CLIENT IP)
 LDX #3
 LDY #19 ; YADDR OFFSET
:OFL2 LDA (INPBUF),Y
 STA DHCPYADDR,X
 DEY
 DEX
 BPL :OFL2
* SEND REQUEST
 JMP DHCPSENDREQ
*
*
:ACK
 LDA DHCPSTAT
 CMP #1
 BNE :ACK2
 JMP DHCPACK
:ACK2
 RTS
*
*
* IF WE GET A NAK IN RESPONSE TO OUR REQUEST, WE NEED TO
* START THE CONFIGURATION PROCESS ALL OVER.
:NAK
DHCPNAK
 LDA #0
 LDX #3
:NAKL STA DHCPYADDR,X ; CLEAR OUR OFFERED IP ADDR
 DEX
 BPL :NAKL
 LDX #3
:NAKL2 STA DHCPSERVER,X ; CLEAR THE SERVER ADDR
 DEX
 BPL :NAKL2
 STA DHCPSTAT ; SET STATUS TO DISCOVER
 JSR DHCPNEXTID
 RTS
*
*
* SEND DHCP REQUEST
DHCPSENDREQ
 LDA #1
 STA DHCPSTAT
 LDA #<DHCPREQDAT
 STA OUTPBUF
 LDA #>DHCPREQDAT
 STA OUTPBUF+1
* COPY DHCP TRANSACTION ID
 LDY #3
 LDX #7
:L LDA DHCPXID,Y
 STA DHCPREQDAT,X
 DEX
 DEY
 BPL :L
* COPY SECONDS ELAPSED
 LDA DHCPSECS
 STA DHCPREQDAT+9 ; OFFSET FOR SECS
 LDA DHCPSECS+1 ; HIGH-BYTE
 STA DHCPREQDAT+8
* REQUEST LENGTH
 LDA #<DHCPREQLEN
 STA OUTPLEN
 LDA #>DHCPREQLEN
 STA OUTPLEN+1
* COPY REQUESTED IP
 LDX #3 ; DHCPYADDR OFFSET
 LDY #27 ; DHCPREQOPT OFFSET
:L2 LDA DHCPYADDR,X
 STA DHCPREQOPT,Y
 DEY
 DEX
 BPL :L2
* COPY SERVER IDENTIFIER
 LDX #3
 LDY #33
:L3 LDA DHCPSERVER,X
 STA DHCPREQOPT,Y
 DEY
 DEX
 BPL :L3
*
 DO DEBUG
 LDY #0
:ML LDA MSG18,Y
 BEQ :NEXT
 JSR COUT
 INY
 BNE :ML
 FIN
* CONFIGURE UDP AND IP HEADERS
* AND SEND
:NEXT JMP DHCPSEND2
* AND WE'RE DONE.
*
*
* DATA TEMPLATE FOR DHCP REQUEST MESSAGES.
DHCPREQDAT
 HEX 01010600
 HEX 00000000 ; TRANSACTION ID
 HEX 0000 ; SECONDS ELAPSED
 HEX 0000 ; BOOTP FLAGS
 DS 16 ; 4 IP ADDRESSES
 DS 16 ; CLIENT HARDWARE ADDRESS
 DS 192 ; BOOTP LEGACY FIELD
 HEX 63825363 ; MAGIC COOKIE
DHCPREQOPT
 HEX 350103 ; DHCP MESSAGE TYPE
 HEX 37040103060F
 HEX 390205DC ; MAX DHCP MESSAGE SIZE
 HEX 3D0701000000000000 ; CLIENT IDENTIFIER
 HEX 320400000000 ; REQUESTED IP ADDRESS
 HEX 360400000000 ; DHCP SERVER IDENTIFIER
 HEX FF ; END OPTIONS
 HEX 00
DHCPREQLEN EQU *-DHCPREQDAT
*
*
* PROCESS THE PARAMETERS GIVEN IN A DHCP ACK MESSAGE
* INPBUF SHOULD BE POINTING AT THE DHCP OPTIONS
DHCPACK
 LDA #51 ; LEASE TIME
 JSR DHCPSCANOPT
 BCS :NETMASK
 CLC
 TYA
 ADC #5
 TAY
 LDX #3 ; OFFSET FOR DHCPLETIME
:L LDA (INPBUF),Y
 STA DHCPLETIME,X
 DEY
 DEX
 BPL :L
:NETMASK LDA #1
 JSR DHCPSCANOPT
 BCS :ERRDONE
 CLC
 TYA
 ADC #5
 TAY
 LDX #3 ; OFFSET FOR NETMASK
:L2 LDA (INPBUF),Y
 STA NETMASK,X
 DEY
 DEX
 BPL :L2
* ROUTER
 LDA #3
 JSR DHCPSCANOPT
 BCS :ERRDONE
 CLC
 TYA
 ADC #5
 TAY
 LDX #3 ; OFFSET FOR ROUTER
:L3 LDA (INPBUF),Y
 STA ROUTER,X
 DEY
 DEX
 BPL :L3
* DOMAIN NAME SERVERS. WE WILL TAKE UP TO 2 ADDRESSES.
 LDA #6
 JSR DHCPSCANOPT
 BCS :ERRDONE
 INY
 LDA (INPBUF),Y ; LENGTH / 4 =
 LSR  ; NUMBER OF SERVERS
 LSR
 PHA
* COPY FIRST DNS SERVER
 INY ; FIRST BYTE OF IP ADDR
 LDX #0 ; OFFSET FOR NAMESERVER1
:L4 LDA (INPBUF),Y
 STA NAMESERVER1,X
 INY
 INX
 CPX #4
 BNE :L4
* NOW CHECK FOR A SECOND SERVER
 PLA
 CMP #2
 BCC :NEXT ; NO SECOND SERVER
* COPY 2ND SERVER
 LDX #0
:L5 LDA (INPBUF),Y
 STA NAMESERVER2,X
 INY
 INX
 CPX #4
 BNE :L5
* BACKUP INPBUF TO GET OUR ASSIGNED IP ADDR
:NEXT
 SEC
 LDA INPBUF
 SBC #240
 STA INPBUF
 LDA INPBUF+1
 SBC #0
 STA INPBUF+1
 LDY #19 ; OFFSET FOR YADDR
 LDX #3 ; OFFSET FOR IPADDR
:L6 LDA (INPBUF),Y
 STA IPADDR,X
 DEY
 DEX
 BPL :L6
* UPDATE IPCONFMODE AND DHCP STATUS
 LDA #2 ; MODE = DHCP
 STA IPCONFMODE
 STA DHCPSTAT ; STATUS = BOUND
* FINISH IP CONFIGURATION
 JMP IPCONFIG2
* ERROR
:ERRDONE
 RTS
*
* SEND A DHCP DECLINE MESSAGE
* THIS IS *ONLY* USED WHEN WE DISCOVER THAT THE DHCP SERVER
* HAS SENT US AN IP ADDRESS THAT IS ALREADY IN USE.
DHCPSENDDEC
 LDA #0 ; STATUS BACK TO INIT
 STA DHCPSTAT
 LDA #<DHCPDECDAT
 STA OUTPBUF
 LDA #>DHCPDECDAT
 STA OUTPBUF+1
* COPY DHCP TRANSACTION ID
 LDY #3
 LDX #7
:L LDA DHCPXID,Y
 STA DHCPDECDAT,X
 DEX
 DEY
 BPL :L
* REQUEST LENGTH
 LDA #<DHCPDECLEN
 STA OUTPLEN
 LDA #>DHCPDECLEN
 STA OUTPLEN+1
* COPY REQUESTED (YOUR) ADDRESS
 LDX #3 ; DHCPYADDR OFFSET
 LDY #17 ; DHCPDECOPT OFFSET
:L2 LDA DHCPYADDR,X
 STA DHCPDECOPT,Y
 DEY
 DEX
 BPL :L2
* COPY SERVER IDENTIFIER
 LDX #3
 LDY #23
:L3 LDA DHCPSERVER,X
 STA DHCPDECOPT,Y
 DEY
 DEX
 BPL :L3
* CLEAR OUR DHCP SETTINGS
 JSR DHCPNAK
* CONFIGURE UDP AND IP HEADERS AND SEND
 JMP DHCPSEND2
* AND THAT'S IT
*
*
* DATA TEMPLATE FOR DHCP DECLINE MESSAGES.
DHCPDECDAT
 HEX 01010600
 HEX 00000000 ; TRANSACTION ID
 HEX 0000 ; SECONDS ELAPSED
 HEX 0000 ; BOOTP FLAGS
 DS 16 ; 4 IP ADDRESSES
 DS 16 ; CLIENT HARDWARE ADDRESS
 DS 192 ; BOOTP LEGACY FIELD
 HEX 63825363 ; MAGIC COOKIE
DHCPDECOPT
 HEX 350104 ; DHCP MESSAGE TYPE
 HEX 3D0701000000000000 ; CLIENT IDENTIFIER
 HEX 320400000000 ; REQUESTED IP ADDRESS
 HEX 360400000000 ; DHCP SERVER IDENTIFIER
 HEX FF ; END OPTIONS
DHCPDECLEN EQU *-DHCPDECDAT
*
*
* DHCP OPTIONS SCANNER
* THIS WILL LOOK FOR A PARTICULAR OPTION CODE.
* PUT DESIRED CODE IN A-REG. INPBUF NEEDS TO POINT TO START
* OF OPTIONS FIELD, FIRST BYTE AFTER MAGIC COOKIE.
* IF FOUND, OFFSET RETURNED IN Y-REG,
* CARRY CLEAR. IF NOT FOUND, CARRY SET.
DHCPSCANOPT
 LDY #0 ; OFFSET
 TAX  ; KEEP CODE IN X-REG
:L CMP (INPBUF),Y
 BEQ :MATCH ; FOUND IT!
 LDA (INPBUF),Y
 BEQ :NEXT ; 0 = PAD OPTION
 CMP #$FF
 BEQ :NOMATCH ; AT END OF OPTIONS
 INY  ; POINT TO LENGTH
 CLC
 TYA
 ADC (INPBUF),Y ; ADD LENGTH FIELD
 TAY
:NEXT INY
 TXA ; GET TARGET CODE BACK
 BNE :L
:NOMATCH
 SEC
 RTS
:MATCH
 CLC
 RTS
